//---------------------------------------------------------------------------
#include <GL/glut.h>
#ifndef UHorseH
#define UHorseH
#define FRAMES 30
//---------------------------------------------------------------------------
class PataDianteira {
protected:
  int lado,
      anguloSuperior,
      anguloMedio,
      anguloInferior;
public:
  PataDianteira(int __lado);
  void setAnguloSuperior(int __anguloSuperior);
  void setAnguloInferior(int __anguloInferior);
  void setAnguloMedio(int __anguloMedio);
  void setAngulos(double __posicaoMovimento, int __tipoCaminhada);
  void desenha(int __lado);
};

//---------------------------------------------------------------------------
class PataTraseira {
protected:
  int lado,
      anguloSuperior,
      anguloMedioSup,
      anguloMedioInf,
      anguloInferior;
public:
  PataTraseira(int __lado);
  void setAnguloSuperior(int __anguloSuperior);
  void setAnguloInferior(int __anguloInferior);
  void setAnguloMedio(int __anguloMedio);
  void setAngulos(double __posicaoMovimento, int __tipoCaminhada);
  void desenha(int __lado);
};

//---------------------------------------------------------------------------
class Rabo {
protected:
  int anguloZ, anguloX;
public:
  Rabo();
  void desenha();
  void setAngulos(double __posicaoMovimento, int __tipoCaminhada);
};

//---------------------------------------------------------------------------
class Cabeca {
protected:
  int anguloPescoco;
public:
  Cabeca();
  void setAnguloPescoco(double __posicaoMovimento, int __tipoCaminhada);
  void desenha();
};

//---------------------------------------------------------------------------
class Corpo {
protected:
  int tipoCaminhada;
  Cabeca* cabeca;
  Rabo* rabo;
  PataDianteira* pataDiantDireita;
  PataDianteira* pataDiantEsquerda;
  PataTraseira*  pataTrasDireita;
  PataTraseira*  pataTrasEsquerda;
public:
  Corpo();
  void setTipoCaminhada(int __tipoCaminhada);
  void setPosicao(double __posicaoMovimento);
  void desenha();
};
//---------------------------------------------------------------------------
#endif
